/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public final class ItemPickup
implements IPickupEntry {
    public static final class_2487 EMPTY_TAG = new class_2487();
    private final class_1799 stack;
    private int count;
    private int total;

    public ItemPickup(class_1799 stack) {
        this.stack = stack;
        this.count = stack.method_7947();
        this.countTotal(this.count);
    }

    @Override
    public class_5250 getDisplayName() {
        class_2583 style = LootJournal.CONFIG.itemEntryUseItemFormatting ? this.stack.method_7954().method_10866().method_10978(Boolean.valueOf(this.stack.method_7938())) : LootJournal.CONFIG.itemEntryStyle;
        class_5250 name = this.stack.method_7964().method_27661().method_27696(style);
        class_5250 result = this.count <= 1 ? class_2561.method_43469((String)"pickup.loot_journal.item_single", (Object[])new Object[]{name}) : class_2561.method_43469((String)"pickup.loot_journal.item_multiple", (Object[])new Object[]{name, this.count});
        return result.method_27696(style);
    }

    @Override
    public int getTotalAmount() {
        return this.total;
    }

    @Override
    public void renderIcon(class_332 graphics, long time) {
        graphics.method_51445(this.stack, -8, -8);
    }

    @Override
    public boolean maybeMerge(IPickupEntry pickup) {
        if (!(pickup instanceof ItemPickup)) {
            return false;
        }
        ItemPickup other = (ItemPickup)pickup;
        if (!class_1799.method_31577((class_1799)this.stack, (class_1799)other.stack)) {
            return false;
        }
        this.count += other.count;
        this.countTotal(other.count);
        return true;
    }

    @Override
    public boolean shouldDisplayTotalAmount() {
        return LootJournal.CONFIG.itemEntryDisplayTotalAmount && this.total > 1;
    }

    private void countTotal(int origin) {
        this.total = origin;
        if (!LootJournal.CONFIG.itemEntryDisplayTotalAmount) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        for (class_1799 stack : player.method_31548().field_7547) {
            this.total += this.countSameItems(stack);
        }
    }

    private int countSameItems(class_1799 stack) {
        class_2487 compoundTag;
        class_2499 listTag;
        Object object;
        int searched = 0;
        if (class_1799.method_31577((class_1799)this.stack, (class_1799)stack)) {
            searched += stack.method_7947();
        }
        if ((object = Optional.ofNullable(stack.method_7969()).orElse(EMPTY_TAG).method_10562("BlockEntityTag").method_10580("Items")) instanceof class_2499) {
            listTag = (class_2499)object;
            object = listTag.stream().toList().iterator();
            while (object.hasNext()) {
                class_2520 tagIn = (class_2520)object.next();
                if (!(tagIn instanceof class_2487)) continue;
                compoundTag = (class_2487)tagIn;
                searched += this.countSameItems(class_1799.method_7915((class_2487)compoundTag));
            }
        }
        if ((object = Optional.ofNullable(stack.method_7969()).orElse(EMPTY_TAG).method_10580("Items")) instanceof class_2499) {
            listTag = (class_2499)object;
            for (class_2520 tagIn : listTag.stream().toList()) {
                if (!(tagIn instanceof class_2487)) continue;
                compoundTag = (class_2487)tagIn;
                searched += this.countSameItems(class_1799.method_7915((class_2487)compoundTag));
            }
        }
        return searched;
    }
}

